﻿Imports Microsoft.Office.Interop

Public Class Form1
    Private Sub cboRecurrence_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboRecurrence.SelectedIndexChanged
        '
        '此方法用于根据所选定期类型设置最大“时间间隔”值
        Select Case Me.cboRecurrence.Text
            Case "Minutes" : Me.udEvery.Maximum = 1439
            Case "Hours" : Me.udEvery.Maximum = 23
            Case "Days" : Me.udEvery.Maximum = 365
        End Select
    End Sub
    Private Sub cmdLoadSpreadsheet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdLoadSpreadsheet.Click
        Dim dt As DataTable
        dt = PopulateExcelWorkbook("", True)
        Me.grdOrder.DataSource = dt
    End Sub
    Private Sub btnRemoveRecurrence_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRemoveRecurrence.Click
        Shell("SCHTASKS /DELETE /TN ExcelAuto /F", AppWinStyle.Hide, True, 1000)
    End Sub
    Private Sub cmdSchedule_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSchedule.Click
        Dim strCommand As String
        Dim strTask As String
        Dim key As Microsoft.Win32.RegistryKey
        '
        '移除任何现有时间表
        Shell("SCHTASKS /DELETE /TN ExcelAuto /F", AppWinStyle.Hide, True, 1000)
        '
        '创建用于安排任务进度的命令行
        strTask = """""""""" & My.Application.Info.DirectoryPath & "\ExcelAutoTask.exe" & """"""""""

        strCommand = "SCHTASKS /CREATE "
        Select Case Me.cboRecurrence.Text
            Case "Minutes" : strCommand &= " /SC MINUTE"
            Case "Hours" : strCommand &= " /SC HOURLY"
            Case "Days" : strCommand &= " /SC DAILY"
        End Select
        strCommand &= " /MO " & udEvery.Value                           'every 参数
        strCommand &= " /TN ExcelAuto"                                  '任务名称
        strCommand &= " /SD " & Format(Me.datStart.Value, "short date") '开始日期
        strCommand &= " /ST " & Format(Me.datStart.Value, "HH:mm:ss")   '开始时间
        strCommand &= " /RU SYSTEM"                                     '用于运行的帐户
        strCommand &= " /TR " & strTask                                 '要执行的命令
        '
        '安排任务进度
        Shell(strCommand, AppWinStyle.Hide)
        '
        '将要向其发送电子邮件的电子邮件地址和 SMTP 主机存储在注册表中
        key = My.Computer.Registry.LocalMachine.CreateSubKey("SOFTWARE\ExcelAuto")
        key.SetValue("EmailAddress", Me.txtEmailAddress.Text)
        key.SetValue("SMTPHost", Me.txtSMTPHost.Text)
        MsgBox("Task scheduled")
    End Sub
    Private Sub cmdEmail_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdEmailOutlook.Click, cmdEmailSMTP.Click
        Dim key As Microsoft.Win32.RegistryKey
        Dim strSaveFilename As String
        '
        '将要向其发送电子邮件的电子邮件地址和 SMTP 主机存储在注册表中
        key = My.Computer.Registry.LocalMachine.CreateSubKey("SOFTWARE\ExcelAuto")
        key.SetValue("EmailAddress", Me.txtEmailAddress.Text)
        key.SetValue("SMTPHost", Me.txtSMTPHost.Text)
        '
        strSaveFilename = My.Computer.FileSystem.SpecialDirectories.Temp & "\Report " & Format(Now, "d-MMM-yyy HH.mm") & ".xlsx"
        PopulateExcelWorkbook(strSaveFilename, False)
        If sender Is Me.cmdEmailSMTP Then
            SendExcelMailViaSMTP(Me.txtEmailAddress.Text, "VB2005@example.com", strSaveFilename, Me.txtSMTPHost.Text, True)
        Else
            SendExcelMailViaOutlook(Me.txtEmailAddress.Text, "VB2005@example.com", strSaveFilename, Me.txtSMTPHost.Text, True)
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '
        '如果已将要向其发送电子邮件的电子邮件地址存储在注册表中，
        '则检索该地址，然后将其显示在电子邮件地址文本框中
        Dim key As Microsoft.Win32.RegistryKey
        key = My.Computer.Registry.LocalMachine.OpenSubKey("SOFTWARE\ExcelAuto")
        If Not key Is Nothing Then
            Me.txtEmailAddress.Text = key.GetValue("EmailAddress")
            Me.txtSMTPHost.Text = key.GetValue("SMTPHost")
        End If
    End Sub
End Class
